package com.example.demo.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.*;
import lombok.Data;

import java.time.LocalDateTime;

@Entity
@Table(name = "yw_biddingfile_similaritydetail")
@Data
@Schema(description = "投标文件雷同明细")
public class YwBiddingfileSimilarityDetail {

    @Id
    @Column(length = 50)
    @Schema(description = "行唯一标识", example = "550e8400-e29b-41d4-a716-446655440000")
    private String rowguid;

    @Column(length = 500, nullable = false)
    @Schema(description = "标段名称", example = "XX高速公路建设项目第1标段", required = true)
    private String biaoduanname;

    @Column(length = 50, nullable = false)
    @Schema(description = "标段编号", example = "BD-2023-001", required = true)
    private String biaoduanno;

    @Column(length = 500, nullable = false)
    @Schema(description = "投标单位名称", example = "XX建设集团有限公司", required = true)
    private String danweiname;

    @Column(length = 50)
    @Schema(description = "投标单位统一社会信用代码",
            example = "91330100MA2J5R1234")
    private String danweiguid;

    @Schema(description = "文件雷同状态 0否 1是",
            example = "1",
            allowableValues = {"0", "1"}
    )
    private Integer similaritystatus;

    @Schema(description = "雷同单位数量",
            example = "3",
            minimum = "0"
            )
    private Integer similarityorgnum;

    @Schema(description = "数据推送时间",
            example = "2023-12-15T14:30:00",
            pattern = "yyyy-MM-dd'T'HH:mm:ss")
    private LocalDateTime senddate;
}