package com.example.demo.controller;

import com.example.demo.dto.ERoadPushBid;
import com.example.demo.dto.ERoadPushTender;
import com.example.demo.dto.SupervisorPlatformResponse;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.tags.Tag;
import lombok.RequiredArgsConstructor;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.*;
import com.example.demo.service.ERoadService;

@RestController
@RequestMapping("/api/eRoad")
@RequiredArgsConstructor
@Tag(name = "e路阳光")
public class ERoadController {

    private final ERoadService eService;

    @PostMapping("/writeSimilarityDetailAndInfo")
    @Operation(
            description = "写入投标文件雷同分析表和雷同明细",
            summary = "写入投标文件雷同分析表和雷同明细"
    )
    public ResponseEntity<?> writeSimilarityDetail(@RequestBody ERoadPushTender request){
        String infoMessage =  eService.writeSimilarityInfo(request.getYwBiddingfileSimilarityInfoRequest());
        String detailMessage = eService.writeSimilarityDetail(request.getYwBiddingfileSimilarityDetailRequest());
        SupervisorPlatformResponse response = new SupervisorPlatformResponse();
        response.setMsg(infoMessage+";"+detailMessage);
        return ResponseEntity.ok(response);
    }

    @PostMapping("/writeReviewDetailAndInfo")
    @Operation(
            description = "写入招标文件审查基础表和明细结果表",
            summary = "写入招标文件审查基础表和明细结果表"
    )
    public ResponseEntity<?> writeReviewDetail(@RequestBody ERoadPushBid request){
        String infoMessage =  eService.batchWriteReviewDetail(request.getYwBidfileReviewDetailListRequest());
        String detailMessage = eService.writeReviewInfo(request.getYwBidfileReviewInfoRequest());
        SupervisorPlatformResponse response = new SupervisorPlatformResponse();
        response.setMsg(infoMessage+";"+detailMessage);
        return ResponseEntity.ok(response);
    }
}
