package com.example.demo.service;

import com.example.demo.dto.*;
import com.example.demo.entity.YwBiddingfileSimilarityDetail;
import com.example.demo.entity.YwBiddingfileSimilarityInfo;
import com.example.demo.entity.YwBidfileReviewDetail;
import com.example.demo.entity.YwBidfileReviewInfo;
import com.example.demo.repository.YwBiddingfileSimilarityDetailRepository;
import com.example.demo.repository.YwBiddingfileSimilarityInfoRepository;
import com.example.demo.repository.YwBidfileReviewDetailRepository;
import com.example.demo.repository.YwBidfileReviewInfoRepository;
import lombok.RequiredArgsConstructor;
import org.springframework.beans.BeanUtils;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
public class ERoadService {

    private final YwBiddingfileSimilarityDetailRepository similarityDetailRepository;
    private final YwBiddingfileSimilarityInfoRepository  similarityInfoRepository;
    private final YwBidfileReviewDetailRepository  reviewDetailRepository;
    private final YwBidfileReviewInfoRepository reviewInfoRepository;
    private final YwBidfileReviewInfoRepository ywBidfileReviewInfoRepository;
    private final YwBiddingfileSimilarityInfoRepository ywBiddingfileSimilarityInfoRepository;
    private final YwBiddingfileSimilarityDetailRepository ywBiddingfileSimilarityDetailRepository;

    private YwBiddingfileSimilarityDetail convertToEntitySimilarDetail(YwBiddingfileSimilarityDetailRequest request){
        YwBiddingfileSimilarityDetail entity = new YwBiddingfileSimilarityDetail();
        // 复制属性
        BeanUtils.copyProperties(request, entity, "senddate");
        if (request.getSenddate() != null) {
            entity.setSenddate(LocalDateTime.parse(request.getSenddate()));
        }
        List<YwBiddingfileSimilarityDetail> ywBiddingfileSimilarityDetails =ywBiddingfileSimilarityDetailRepository.findByBiaoduanno(entity.getBiaoduanno());
        if(!ywBiddingfileSimilarityDetails.isEmpty()){
            entity.setRowguid(ywBiddingfileSimilarityDetails.get(0).getRowguid());
        }
        return entity;
    }
    /**
     * 转换Request为Entity
     */
    private YwBiddingfileSimilarityInfo convertToEntitySimilarInfo(YwBiddingfileSimilarityInfoRequest request) {
        YwBiddingfileSimilarityInfo entity = new YwBiddingfileSimilarityInfo();

        // 复制属性
        BeanUtils.copyProperties(request, entity, "kaibiaodate", "reportdate","senddate");

        // 处理日期
        if (request.getSenddate() != null) {
            entity.setSenddate(LocalDateTime.parse(request.getSenddate()));
        }
        if (request.getReportdate() != null) {
            entity.setReportdate(LocalDateTime.parse(request.getReportdate()));
        }
        if(request.getKaibiaodate() !=null) {
            entity.setKaibiaodate(LocalDateTime.parse(request.getKaibiaodate()));
        }
        List<YwBiddingfileSimilarityInfo> ywBiddingfileSimilarityInfos =ywBiddingfileSimilarityInfoRepository.findByBiaoduanno(entity.getBiaoduanno());
        if(!ywBiddingfileSimilarityInfos.isEmpty()){
            entity.setRowguid(ywBiddingfileSimilarityInfos.get(0).getRowguid());
        }
        return entity;
    }

    public String writeSimilarityDetail(List<YwBiddingfileSimilarityDetailRequest> request){
        if (request==null) {
            return "投标文件雷同明细不能为空";
        }
        List<YwBiddingfileSimilarityDetail> entity = convertToEntitySimilarityList(request);
        ywBiddingfileSimilarityDetailRepository.saveAll(entity);
        return "投标文件雷同明细更新成功";
    }

    public String writeSimilarityInfo(YwBiddingfileSimilarityInfoRequest request){
        if (request==null) {
            return "投标文件雷同分析表不能为空";
        }
        YwBiddingfileSimilarityInfo entity = convertToEntitySimilarInfo(request);
        ywBiddingfileSimilarityInfoRepository.save(entity);
        return "投标文件雷同分析表更新成功";
    }

    /**
     * 转换Request为Entity
     */
    private YwBidfileReviewDetail convertToEntity(YwBidfileReviewDetailRequest request) {
        YwBidfileReviewDetail entity = new YwBidfileReviewDetail();

        // 复制属性
        BeanUtils.copyProperties(request, entity, "senddate");

        // 处理日期
        if (request.getSenddate() != null) {
            entity.setSenddate(LocalDateTime.parse(request.getSenddate()));
        }
        List<YwBidfileReviewDetail> ywBidfileReviewDetail =reviewDetailRepository.findByBiaoduannoAndChecktype(entity.getBiaoduanno(), entity.getChecktype());
        if(!ywBidfileReviewDetail.isEmpty()){
            entity.setRowguid(ywBidfileReviewDetail.get(0).getRowguid());
        }
        return entity;
    }

    private YwBidfileReviewInfo convertToEntityInfo(YwBidfileReviewInfoRequest request) {
        YwBidfileReviewInfo entity = new YwBidfileReviewInfo();

        // 复制属性
        BeanUtils.copyProperties(request, entity, "senddate","complianceCheckDate","consistencyCheckDate","wordCheckDate");

        // 处理日期
        if (request.getSenddate() != null) {
            entity.setSenddate(LocalDateTime.parse(request.getSenddate()));
        }
        if(request.getCompliancecheckdate()!=null){
            entity.setCompliancecheckdate(LocalDateTime.parse(request.getCompliancecheckdate()));
        }
        if(request.getConsistencycheckdate()!=null){
            entity.setConsistencycheckdate(LocalDateTime.parse(request.getConsistencycheckdate()));
        }
        if(request.getWordcheckdate()!=null){
            entity.setWordcheckdate(LocalDateTime.parse(request.getWordcheckdate()));
        }

        return entity;
    }

    /**
     * 批量转换
     */
    private List<YwBidfileReviewDetail> convertToEntityList(List<YwBidfileReviewDetailRequest> requests) {
        return requests.stream()
                .map(this::convertToEntity)
                .collect(Collectors.toList());
    }

    private List<YwBiddingfileSimilarityDetail> convertToEntitySimilarityList(List<YwBiddingfileSimilarityDetailRequest> requests) {
        return requests.stream()
                .map(this::convertToEntitySimilarDetail)
                .collect(Collectors.toList());
    }

    /**
     * 批量保存
     */
    public String batchWriteReviewDetail(List<YwBidfileReviewDetailRequest> requests) {
        if (CollectionUtils.isEmpty(requests)) {
            return "招标文件审查基础表信息不能为空";
        }

        List<YwBidfileReviewDetail> entities = convertToEntityList(requests);
        reviewDetailRepository.saveAll(entities);
        return "招标文件审查基础表信息更新成功";
    }

    public String writeReviewInfo(YwBidfileReviewInfoRequest request){
         SupervisorPlatformResponse supervisorPlatformResponse = new SupervisorPlatformResponse();

            if (request==null) {
                return "招标文件审查明细结果表不能为空";
            }
            YwBidfileReviewInfo entity = convertToEntityInfo(request);
            List<YwBidfileReviewInfo> ywBidfileReviewInfo = ywBidfileReviewInfoRepository.findByBiaoduanno(entity.getBiaoduanno());
            if(!ywBidfileReviewInfo.isEmpty()){
                entity.setRowguid(ywBidfileReviewInfo.get(0).getRowguid());
            }
            reviewInfoRepository.save(entity);
            return "招标文件审查明细结果表更新成功";
        }
}
