package com.example.demo.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.*;
import lombok.Data;
import org.hibernate.annotations.DynamicUpdate;

import java.time.LocalDateTime;

@Entity
@Data
@DynamicUpdate
@Schema(name = "招标文件审查基础表")
@Table(name = "yw_bidfile_reviewinfo")
public class YwBidfileReviewInfo {

    @Id
    @Column(length = 50)
    @Schema(description = "行唯一标识", example = "123e4567-e89b-12d3-a456-426614174000")
    private String rowguid;

    @Column(length = 500, nullable = false)
    @Schema(description = "标段名称", example = "XX高速公路建设项目第1标段", required = true)
    private String biaoduanname;

    @Column(length = 50, nullable = false)
    @Schema(description = "标段编号", example = "BD-2023-001", required = true)
    private String biaoduanno;

    @Column(length = 200)
    @Schema(description = "招标单位名称", example = "XX省交通建设集团有限公司")
    private String jianshedanwei;

    @Column(length = 200)
    @Schema(description = "招标代理名称", example = "XX招标代理有限公司")
    private String dailiname;

    @Schema(description = "错敏词审查日期", example = "2023-12-15T09:30:00")
    private LocalDateTime wordcheckdate;

    @Schema(description = "一致性审查日期", example = "2023-12-16T10:30:00")
    private LocalDateTime consistencycheckdate;

    @Schema(description = "合规性审查日期", example = "2023-12-17T11:30:00")
    private LocalDateTime compliancecheckdate;

    @Column(length = 50, nullable = false)
    @Schema(description = "审查范围1.错敏词检查 2.一致性检查 3.合规性检查 英文分号隔开，如：1;2;3",
            example = "1;2;3"
            )
    private String checkscope;

    @Column(length = 200, nullable = false)
    @Schema(description = "组织名称", example = "XX审查中心", required = true)
    private String organization;

    @Column(length = 200, nullable = false)
    @Schema(description = "审查报告地址",
            example = "http://example.com/reports/check_report_2023001.pdf",
            required = true)
    private String url;

    @Schema(description = "数据推送时间", example = "2023-12-18T14:00:00")
    private LocalDateTime senddate;

}
