package com.example.demo.entity;

import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.persistence.*;
import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;

@Entity
@Data
@Table(name = "yw_bidfile_reviewdetail")
@Schema(name = "招标文件审查明细结果表")
public class YwBidfileReviewDetail {
    @Id
    @Column(length = 50)
    @Schema(description = "行唯一标识",
            example = "550e8400-e29b-41d4-a716-446655440000")
    private String rowguid;

    @Column(length = 500, nullable = false)
    @Schema(description = "标段名称",
            example = "XX市轨道交通3号线二期工程土建施工02标段",
            maxLength = 500
            )
    private String biaoduanname;

    @Column(length = 50, nullable = false)
    @Schema(description = "标段编号",
            example = "BD202312-002")
    private String biaoduanno;

    @Column(length = 2, nullable = false)
    @Schema(description = "审查类型 1.错敏词检查 2.一致性检查 3.合规性检查",
            example = "1",
            allowableValues = {"1", "2", "3"})
    private String checktype;

    @Schema(description = "检查次数",
            example = "3",
            minimum = "0",
            defaultValue = "0")
    private Integer checktimes;

    @Schema(description = "存疑点数",
            example = "15",
            minimum = "0"
            )
    private Integer storagepoint;

    @Schema(description = "反馈数",
            example = "12",
            minimum = "0"
            )
    private Integer feedbacknum;

    @Schema(description = "未反馈数",
            example = "3",
            minimum = "0"
            )
    private Integer unfeedbackednum;

    @Schema(description = "采纳建议数",
            example = "8",
            minimum = "0"
            )
    private Integer adoptednum;

    @Schema(description = "准确率",
            example = "0.8750",
            minimum = "0",
            maximum = "1"
            )
    @Column(precision = 20, scale = 8)
    private BigDecimal accuracy;

    @Schema(description = "数据推送时间",
            example = "2023-12-15T14:30:00",
            pattern = "yyyy-MM-dd'T'HH:mm:ss")
    private LocalDateTime senddate;

}
