package com.example.demo.dto;

import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class YwBiddingfileSimilarityInfoRequest {


    @Schema(description = "行唯一标识", example = "550e8400-e29b-41d4-a716-446655440000", maxLength = 50)
    private String rowguid;

    @Schema(description = "标段名称", example = "XX高速公路第1标段", required = true, maxLength = 500)
    private String biaoduanname;

    @Schema(description = "标段编号", example = "BD2023001", required = true, maxLength = 50)
    private String biaoduanno;

    @Schema(description = "项目名称", example = "XX高速公路建设项目", required = true, maxLength = 500)
    private String projectname;

    @Schema(description = "项目编号", example = "XM2023001", required = true, maxLength = 50)
    private String projectno;

    @Schema(description = "1：交通 2：水利  3：住建", example = "1", required = true, maxLength = 50)
    private String projectjiaoyitype;

    @Schema(description = "招标单位名称", example = "XX省交通建设集团有限公司", maxLength = 200)
    private String jianshedanwei;

    @Schema(description = "招标代理名称", example = "XX招标代理有限公司", maxLength = 200)
    private String dailiname;

    @Schema(description = "中标单位统一社会信用代码", example = "91330100MA2J5R1234", maxLength = 50)
    private String zhongbiaodanweiguid;

    @Schema(description = "中标单位名称", example = "XX建设集团有限公司", required = true, maxLength = 200)
    private String zhongbiaodanwei;

    @Schema(description = "中标金额(元)", example = "125000000.00")
    private BigDecimal zhongbiaojine;

    @Schema(description = "开标时间", example = "2023-06-15T09:30:00")
    private String kaibiaodate;

    @Schema(description = "报告生成日期", example = "2023-06-20T14:00:00")
    private String reportdate;

    @Schema(description = "投标单位文件数量", example = "15")
    private Integer bidfilenum;

    @Schema(description = "雷同投标文件数", example = "3")
    private Integer similarityfilenum;

    @Schema(description = "文件疑似雷同点数", example = "125")
    private Integer similaritynum;

    @Schema(description = "雷同性风险分析报告地址",
            example = "http://example.com/reports/risk_analysis_2023001.pdf",
            required = true,
            maxLength = 200)
    private String url;

    @Schema(description = "数据推送时间", example = "2023-06-21T10:00:00")
    private String senddate;
}
